import numpy as np

class Data:
    def __init__(self, data_type):
        self.n = 0  # Number of nodes
        self.ndata = 0  # Number of data points
        self.data = np.zeros((self.ndata, self.n))  # Data matrix
        self.data_type = data_type
        self.arity = []

    def load_data(self, filename: str):
        self.data = np.loadtxt(filename, dtype=float)
        if self.data_type=='C':
            self.data -= np.mean(self.data, axis=0)  # Center the data
        self.ndata = self.data.shape[0]  # Number of data points
        self.n = self.data.shape[1]  # Number of nodes
        if self.data_type=='D':
            for col in range(self.data.shape[1]): # take each feature
                unique_values = np.unique(self.data[:, col]) # number of values that can take
                self.arity.append(len(unique_values))


    def print_data(self):
        print('Number of nodes:', self.n)
        print('Number of data points:', self.ndata)